﻿//////////////////////////////////////////////
// GlobalTimer.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT GlobalTimer
	{		
		public :

			// Constructor
			GlobalTimer () noexcept ;

			// Setters
			void setModuloTime (unsigned long long moduloTime) ;
		
			// Frame timing
			void updateFrameTime () ;
			unsigned long long getDeltaTime () const ;
			unsigned long long getFrameTime () const ;

			// Modulo timing
			unsigned long long getCurrentModuloTime () const ;
			unsigned long long getCurrentModulo () const ;
			bool getLoopedSinceLastTime () const ;

			// Absolute values
			int getCurrentYear () ;
			int getCurrentMonth () ;
			int getCurrentDay () ;
			int getCurrentHour () ;
			int getCurrentMin () ;
			int getCurrentSec () ;

		private :
		
			// Attributs
			// Last time stamps
			unsigned long long _lastFrameTime ;
			unsigned long long _lastDeltaTime ;

			// To customize behaviour
			unsigned long long _currentModuloTime ;
			unsigned long long _modulo ;
			bool _loopedSinceLastTime ;
	} ;
}